IF  NOT EXISTS (SELECT * FROM SYS.OBJECTS 
					WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[EST_PED_VD_PAG_DUPLICATA_BOLETO]') 
					AND TYPE IN (N'U')) 
BEGIN
	CREATE TABLE [DBO].[EST_PED_VD_PAG_DUPLICATA_BOLETO](
		[CD_CTR] INT IDENTITY(1,1) NOT NULL,
		[PAG_DUPLICATA_CD_CTR] INT NOT NULL,
		[ADQUIRENTE]   		VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',	
		[NOSSO_NUMERO] 		VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[NUMERO_DOCUMENTO] 	VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[CODIGO_BARRAS] 	VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[DT_CAD] DATETIME NOT NULL DEFAULT CONVERT(VARCHAR(10),GETDATE(), 112),
		[DT_VENCTO] DATETIME NOT NULL DEFAULT CONVERT(VARCHAR(10),GETDATE(), 112),
	 CONSTRAINT [PK__EST_PED_VD_PAG_DUPLICATA_BOLETO] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] 

	ALTER TABLE [DBO].[EST_PED_VD_PAG_DUPLICATA_BOLETO]  WITH CHECK ADD  CONSTRAINT [FK__EST_PED_VD_PAG_DUPLICATA_BOLETO__EST_PED_VD_PAG_DUPLICATA] FOREIGN KEY([PAG_DUPLICATA_CD_CTR])
	REFERENCES [DBO].[EST_PED_VD_PAG_DUPLICATA] ([CD_CTR]) 
	ALTER TABLE [DBO].[EST_PED_VD_PAG_DUPLICATA_BOLETO] CHECK CONSTRAINT [FK__EST_PED_VD_PAG_DUPLICATA_BOLETO__EST_PED_VD_PAG_DUPLICATA] 
END